#install.packages("ggplot2")
#install.packages("ggpubr")


#library packages
library(plyr)
library(ggplot2)
library(ggpubr)
groupFile="metabolismcluster.txt"     #group file
cliFile="Response.txt"            #Microsatellite Instability File
setwd("E:\\metabolism\\LGG\\16.ANN_validation\\CGGA\\6.TIDE")     

#read input file
group=read.table(groupFile, header=T, sep="\t", check.names=F, row.names=1)
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)
sameSample=intersect(row.names(group), row.names(cli))
rt=cbind(group[sameSample,,drop=F], cli[sameSample,,drop=F])
rt$Response=factor(rt$Response, levels=c("Response", "Non-response"))
rt$group=factor(rt$group, levels=c("C1", "C2"))
bioCol=c("#16797E","#EABC4B","#C07A92","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
bioCol=bioCol[1:length(unique(rt[,"Response"]))]

#Count the number of patients in high and low group groups
rt1=rt[,c("Response", "group")]
df=as.data.frame(table(rt1))
#Calculate the percentage of high and low group groups
df=ddply(df, .(group), transform, percent = Freq/sum(Freq) * 100)
#Percent position
df=ddply(df, .(group), transform, pos = (cumsum(Freq) - 0.5 * Freq))
df$label=paste0(sprintf("%.0f", df$percent), "%")
#Plot percentage histogram
p=ggplot(df, aes(x = factor(group), y = percent, fill = Response)) +
  geom_bar(position = position_stack(), stat = "identity", width = .7) +
  scale_fill_manual(values=bioCol)+
  xlab("metabolismcluster")+ ylab("Percent weight")+  guides(fill=guide_legend(title="Response"))+
  geom_text(aes(label = label), position = position_stack(vjust = 0.5), size = 3) +
  #coord_flip()+
  theme_bw()
pdf(file="barplot.pdf", width=4, height=5)
print(p)
dev.off()
